import math

def read_input():
    return map(int, input().split())

def calculate_locations(dx, dy, bx, by):

    A = [0 * dx + bx, 0 * dy + by]
    B = [1 * dx + bx, 0 * dy + by]
    C = [2 * dx + bx, 0 * dy + by]
    D = [0 * dx + bx, 1 * dy + by]
    E = [1 * dx + bx, 1 * dy + by]
    F = [2 * dx + bx, 1 * dy + by]
    G = [0 * dx + bx, 2 * dy + by]
    H = [1 * dx + bx, 2 * dy + by]
    I = [2 * dx + bx, 2 * dy + by]

    exit_locations = [A, B, C, D, E, F, G, H, I]

    return exit_locations

def find_nearest_exit(locations, ax, ay):

    distance = math.inf

    for location in locations:
        new_distance = abs(location[0] - ax) + abs(location[1] - ay)
        distance = new_distance if new_distance < distance else distance

    return distance

def main():

    dx, dy = read_input()  # DIMENSIONS
    ax, ay = read_input()  # SHIP POSITION
    bx, by = read_input()  # EXIT POSITION

    locations = calculate_locations(dx, dy, bx, by)

    # Do correction of ship position
    ax += dx
    ay += dy

    result = find_nearest_exit(locations, ax, ay)

    print(result)

if __name__ == '__main__':
    main()